function layout()
return {
forceFeedback = {
trimmer = 1,
shake = 0.5,
swapAxes = false,
invertX = false,
invertY = false,
},
keyCommands = {
{pressed = 3005, cockpit_device_id = 11, value_pressed = -1, name = "Air Cold Decrease", category = "Environment System"},
{pressed = 3005, cockpit_device_id = 11, value_pressed = 1, name = "Air Cold Increase", category = "Environment System"},
{pressed = 3006, cockpit_device_id = 11, value_pressed = -1, name = "Air Hot Decrease", category = "Environment System"},
{pressed = 3006, cockpit_device_id = 11, value_pressed = 1, name = "Air Hot Increase", category = "Environment System"},
{pressed = 3002, cockpit_device_id = 17, value_pressed = -1, name = "Altimeter pressure set Decrease", category = "Front Dash"},
{pressed = 3002, cockpit_device_id = 17, value_pressed = 1, name = "Altimeter pressure set Increase", category = "Front Dash"},
{down = iCommandPlaneEject, name = "Bailout", category = "Systems"},
{down = 3002, cockpit_device_id = 14, value_down = 1, name = "Battery", category = "Right Switch Panel"},
{down = 3017, cockpit_device_id = 13, value_down = 1, name = "Bomb arming switch left (rotary)", category = "Front Switch Box"},
{down = 3009, cockpit_device_id = 13, value_down = -1, name = "Bomb arming switch left ARM", category = "Front Switch Box"},
{down = 3009, cockpit_device_id = 13, value_down = 1, name = "Bomb arming switch left CHEM. RELEASE", category = "Front Switch Box"},
{down = 3009, cockpit_device_id = 13, value_down = 0, name = "Bomb arming switch left OFF", category = "Front Switch Box"},
{down = 3018, cockpit_device_id = 13, value_down = 1, name = "Bomb arming switch right (rotary)", category = "Front Switch Box"},
{down = 3010, cockpit_device_id = 13, value_down = -1, name = "Bomb arming switch right ARM", category = "Front Switch Box"},
{down = 3010, cockpit_device_id = 13, value_down = 1, name = "Bomb arming switch right CHEM. RELEASE", category = "Front Switch Box"},
{down = 3010, cockpit_device_id = 13, value_down = 0, name = "Bomb arming switch right OFF", category = "Front Switch Box"},
{down = 3005, cockpit_device_id = 4, value_down = 1, name = "Bomb salvo release Left", category = "Systems"},
{down = 3006, cockpit_device_id = 4, value_down = 1, name = "Bomb salvo release Right", category = "Systems"},
{down = 3019, cockpit_device_id = 13, value_down = 1, name = "Bomb-rocket selector switch (rotary)", category = "Front Switch Box"},
{down = 3011, cockpit_device_id = 13, value_down = 0.2, name = "Bomb-rocket selector switch BOTH", category = "Front Switch Box"},
{down = 3011, cockpit_device_id = 13, value_down = 0.3, name = "Bomb-rocket selector switch ROCKETS", category = "Front Switch Box"},
{down = 3011, cockpit_device_id = 13, value_down = 0, name = "Bomb-rocket selector switch SAFE", category = "Front Switch Box"},
{down = 3011, cockpit_device_id = 13, value_down = 0.1, name = "Bomb-rocket selector switch TRAIN", category = "Front Switch Box"},
{down = iCommandViewBriefing, name = "Briefing window", category = "General"},
{down = iCommandAWACSHomeBearing, name = "COMM Ask AWACS home airbase (easy communication only)", category = "Communications"},
{down = iCommandPlane_EngageAirDefenses, name = "COMM Attack Air Defenses (easy communication only)", category = "Communications"},
{down = iCommandPlane_EngageGroundTargets, name = "COMM Attack Ground Targets (easy communication only)", category = "Communications"},
{down = iCommandPlaneAttackMyTarget, name = "COMM Attack my target (easy communication only)", category = "Communications"},
{down = iCommandToggleCommandMenu, name = "COMM Communication menu", category = "Communications"},
{down = iCommandPlaneCoverMySix, name = "COMM Cover me (easy communication only)", category = "Communications"},
{down = iCommandPlaneDoAndHome, name = "COMM Dispatch wingmans - complete mission and RTB (easy communication only)", category = "Communications"},
{down = iCommandPlaneDoAndBack, name = "COMM Dispatch wingmans - complete mission and rejoin (easy communication only)", category = "Communications"},
{down = iCommandPlaneJoinUp, name = "COMM Join up formation (easy communication only)", category = "Communications"},
{down = iCommandPlane_P_51_PTT_on, up = iCommandPlane_P_51_PTT_off, name = "COMM Push to talk", category = "Communications"},
{down = ICommandSwitchDialog, name = "COMM Switch dialog", category = "Communications"},
{down = ICommandSwitchToCommonDialog, name = "COMM Switch to main menu", category = "Communications"},
{down = iCommandPlaneFormation, name = "COMM Toggle formation (easy communication only)", category = "Communications"},
{down = iCommandViewCameraJiggle, name = "Camera jiggle toggle", category = "View Extended"},
{down = iCommandViewPlus, name = "Camera ordnance tracking", category = "View Extended"},
{down = iCommandViewKeepTerrain, name = "Camera terrain altitude hold", category = "View Extended"},
{down = iCommandViewTransposeModeOn, up = iCommandViewTransposeModeOff, name = "Camera transpose mode on/off", category = "View Cockpit"},
{down = iCommandViewCameraDown, up = iCommandViewCameraCenter, name = "Camera view down", category = "View Cockpit"},
{down = iCommandViewCameraDownSlow, name = "Camera view down slow", category = "View Cockpit"},
{down = iCommandViewCameraDownLeft, up = iCommandViewCameraCenter, name = "Camera view down-left", category = "View Cockpit"},
{down = iCommandViewCameraDownLeftSlow, name = "Camera view down-left slow", category = "View Cockpit"},
{down = iCommandViewCameraDownRight, up = iCommandViewCameraCenter, name = "Camera view down-right", category = "View Cockpit"},
{down = iCommandViewCameraDownRight, name = "Camera view down-right slow", category = "View Cockpit"},
{down = iCommandViewCameraLeft, up = iCommandViewCameraCenter, name = "Camera view left", category = "View Cockpit"},
{down = iCommandViewCameraLeftSlow, name = "Camera view left slow", category = "View Cockpit"},
{down = iCommandViewCameraRight, up = iCommandViewCameraCenter, name = "Camera view right", category = "View Cockpit"},
{down = iCommandViewCameraRightSlow, name = "Camera view right slow", category = "View Cockpit"},
{down = iCommandViewCameraUp, up = iCommandViewCameraCenter, name = "Camera view up", category = "View Cockpit"},
{down = iCommandViewCameraUpSlow, name = "Camera view up slow", category = "View Cockpit"},
{down = iCommandViewCameraUpLeft, up = iCommandViewCameraCenter, name = "Camera view up-left", category = "View Cockpit"},
{down = iCommandViewCameraUpLeftSlow, name = "Camera view up-left slow", category = "View Cockpit"},
{down = iCommandViewCameraUpRight, up = iCommandViewCameraCenter, name = "Camera view up-right", category = "View Cockpit"},
{down = iCommandViewCameraUpRightSlow, name = "Camera view up-right slow", category = "View Cockpit"},
{pressed = 3004, cockpit_device_id = 6, value_pressed = -1, name = "Canopy Closing", category = "Systems"},
{down = 3005, cockpit_device_id = 6, value_down = 1, name = "Canopy Emergency Release", category = "Systems"},
{pressed = 3004, cockpit_device_id = 6, value_pressed = 1, name = "Canopy Opening", category = "Systems"},
{down = iCommandViewCameraCenter, name = "Center camera view", category = "View Cockpit"},
{down = 3025, up = 3025, cockpit_device_id = 14, value_down = 1, value_up = 0, name = "Circuit Protectors Cover", category = "Right Switch Panel"},
{down = iCommandCockpitClickModeOnOff, name = "Clickable mouse cockpit mode On/Off", category = "General"},
{down = 3003, cockpit_device_id = 22, value_down = 1, name = "Clock Winding/Adjust", category = "Front Dash"},
{pressed = 3004, cockpit_device_id = 22, value_pressed = -1, name = "Clock Winding/Adjust Decrease", category = "Front Dash"},
{pressed = 3004, cockpit_device_id = 22, value_pressed = 1, name = "Clock Winding/Adjust Increase", category = "Front Dash"},
{pressed = iCommandViewPitCameraMoveBack, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Back", category = "View Cockpit"},
{down = iCommandViewPitCameraMoveCenter, name = "Cockpit Camera Move Center", category = "View Cockpit"},
{pressed = iCommandViewPitCameraMoveDown, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Down", category = "View Cockpit"},
{pressed = iCommandViewPitCameraMoveForward, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Forward", category = "View Cockpit"},
{pressed = iCommandViewPitCameraMoveLeft, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Left", category = "View Cockpit"},
{pressed = iCommandViewPitCameraMoveRight, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Right", category = "View Cockpit"},
{pressed = iCommandViewPitCameraMoveUp, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Up", category = "View Cockpit"},
{pressed = 3005, cockpit_device_id = 10, value_pressed = -1, name = "Cockpit Fluorescent Light Left Decrease", category = "Environment System"},
{pressed = 3005, cockpit_device_id = 10, value_pressed = 1, name = "Cockpit Fluorescent Light Left Increase", category = "Environment System"},
{pressed = 3010, cockpit_device_id = 14, value_pressed = -1, name = "Cockpit Fluorescent Light Right Decrease", category = "Environment System"},
{pressed = 3010, cockpit_device_id = 14, value_pressed = 1, name = "Cockpit Fluorescent Light Right Increase", category = "Environment System"},
{pressed = 3003, cockpit_device_id = 13, value_pressed = -1, name = "Cockpit Lights Decrease", category = "Front Switch Box"},
{pressed = 3003, cockpit_device_id = 13, value_pressed = 1, name = "Cockpit Lights Increase", category = "Front Switch Box"},
{down = iCommandViewTempCockpitOn, up = iCommandViewTempCockpitOff, name = "Cockpit panel view in", category = "View Cockpit"},
{down = iCommandViewTempCockpitToggle, name = "Cockpit panel view toggle", category = "View Cockpit"},
{pressed = 3008, cockpit_device_id = 5, value_pressed = 1, name = "Cold Air Control to RAM", category = "Carburetor Air Controls"},
{pressed = 3008, cockpit_device_id = 5, value_pressed = -1, name = "Cold Air Control to UNRAMMED FILTERED", category = "Carburetor Air Controls"},
{pressed = 3002, cockpit_device_id = 23, value_pressed = -1, name = "Compass course Decrease", category = "Front Dash"},
{pressed = 3002, cockpit_device_id = 23, value_pressed = 1, name = "Compass course Increase", category = "Front Dash"},
{down = iCommandPlane_ShowControls, name = "Controls indicator", category = "General"},
{down = iCommandViewCoordinatesInLinearUnits, name = "Coordinates units change", category = "General"},
{pressed = 3004, cockpit_device_id = 11, value_pressed = -1, name = "Defroster Decrease", category = "Environment System"},
{pressed = 3004, cockpit_device_id = 11, value_pressed = 1, name = "Defroster Increase", category = "Environment System"},
{pressed = 3003, cockpit_device_id = 26, value_pressed = -1, name = "Detrola Frequency Selector Decrease", category = "Detrola Receiver"},
{pressed = 3003, cockpit_device_id = 26, value_pressed = 1, name = "Detrola Frequency Selector Increase", category = "Detrola Receiver"},
{pressed = 3004, cockpit_device_id = 26, value_pressed = -1, name = "Detrola Volume Decrease", category = "Detrola Receiver"},
{pressed = 3004, cockpit_device_id = 26, value_pressed = 1, name = "Detrola Volume Increase", category = "Detrola Receiver"},
{down = 3004, cockpit_device_id = 20, value_down = 1, name = "Directional gyro Cage/Uncage", category = "Front Dash"},
{pressed = 3002, cockpit_device_id = 20, value_pressed = -1, name = "Directional gyro heading Decrease", category = "Front Dash"},
{pressed = 3002, cockpit_device_id = 20, value_pressed = 1, name = "Directional gyro heading Increase", category = "Front Dash"},
{pressed = 3024, cockpit_device_id = 5, value_pressed = -1, name = "Engine RPM Decrease", category = "Flight Control"},
{pressed = 3024, cockpit_device_id = 5, value_pressed = 1, name = "Engine RPM Increase", category = "Flight Control"},
{down = iCommandQuit, name = "Exit mission", category = "General"},
{down = iCommandViewCockpit, name = "F1 Cockpit view", category = "View"},
{down = iCommandViewHUDOnlyOnOff, name = "F1 HUD only view switch", category = "View"},
{down = iCommandViewPitHeadOnOff, name = "F1 Head shift movement on / off", category = "View"},
{down = iCommandNaturalViewCockpitIn, name = "F1 Natural head movement view", category = "View"},
{down = iCommandViewAWACSJump, name = "F10 Jump to theater map view over current point", category = "View"},
{down = iCommandViewAWACS, name = "F10 Theater map view", category = "View"},
{down = iCommandViewFree, name = "F11 Airport free camera", category = "View"},
{down = iCommandViewFreeJump, name = "F11 Jump to free camera", category = "View"},
{down = iCommandViewSlowDown, name = "F11 camera moving backward", category = "View"},
{down = iCommandViewSpeedUp, name = "F11 camera moving forward", category = "View"},
{down = iCommandViewMirage, name = "F12 Civil traffic view", category = "View"},
{down = iCommandViewStatic, name = "F12 Static object view", category = "View"},
{down = iCommandViewLocomotivesToggle, name = "F12 Trains/cars toggle", category = "View"},
{down = iCommandViewAir, name = "F2 Aircraft view", category = "View"},
{down = iCommandViewFromTo, name = "F2 Toggle camera position", category = "View"},
{down = iCommandViewLocal, name = "F2 Toggle local camera control", category = "View"},
{down = iCommandViewMe, name = "F2 View own aircraft", category = "View"},
{down = iCommandViewTowerJump, name = "F3 Fly-By jump view", category = "View"},
{down = iCommandViewTower, name = "F3 Fly-By view", category = "View"},
{down = iCommandViewChaseArcade, name = "F4 Arcade View", category = "View"},
{down = iCommandViewChase, name = "F4 Chase view", category = "View"},
{down = iCommandViewRear, name = "F4 Look back view", category = "View"},
{down = iCommandViewFightGround, name = "F5 Ground hostile view", category = "View"},
{down = iCommandViewFight, name = "F5 nearest AC view", category = "View"},
{down = iCommandViewWeapons, name = "F6 Released weapon view", category = "View"},
{down = iCommandViewWeaponAndTarget, name = "F6 Weapon to target view", category = "View"},
{down = iCommandViewJFO, name = "F7 Ground JFO/JTAC view", category = "View"},
{down = iCommandViewGround, name = "F7 Ground unit view", category = "View"},
{down = iCommandViewLndgOfficer, name = "F9 Landing signal officer view", category = "View"},
{down = iCommandViewNavy, name = "F9 Ship view", category = "View"},
{down = 3002, cockpit_device_id = 12, value_down = 0, name = "Flaps Down", category = "Flight Control"},
{down = 3002, cockpit_device_id = 12, value_down = 1, name = "Flaps Up", category = "Flight Control"},
{down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = "Flight Left Wing Down", category = "Flight Control"},
{down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = "Flight Nose Down", category = "Flight Control"},
{down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = "Flight Nose Up", category = "Flight Control"},
{down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = "Flight Right Wing Down", category = "Flight Control"},
{down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = "Flight Rudder Left", category = "Flight Control"},
{down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = "Flight Rudder Right", category = "Flight Control"},
{down = iCommandGraphicsFrameRate, name = "Frame rate counter - Service info", category = "General"},
{down = 3006, cockpit_device_id = 15, value_down = 1, name = "Fuel Booster", category = "Engine Control Panel"},
{combos = {{key = "JOY_BTN17"}, }, down = 3001, cockpit_device_id = 9, value_down = 0.2, name = "Fuel selector Fuselage Tank", category = "Fuel Control"},
{combos = {{key = "JOY_BTN18", reformers = {"JOY_BTN4", }}, }, down = 3001, cockpit_device_id = 9, value_down = 0.4, name = "Fuel selector Left Combat Tank", category = "Fuel Control"},
{combos = {{key = "JOY_BTN18"}, }, down = 3001, cockpit_device_id = 9, value_down = 0.1, name = "Fuel selector Left Main Tank", category = "Fuel Control"},
{combos = {{key = "JOY_BTN16", reformers = {"JOY_BTN4", }}, }, down = 3001, cockpit_device_id = 9, value_down = 0, name = "Fuel selector Right Combat Tank", category = "Fuel Control"},
{combos = {{key = "JOY_BTN16"}, }, down = 3001, cockpit_device_id = 9, value_down = 0.3, name = "Fuel selector Right Main Tank", category = "Fuel Control"},
{down = 3006, cockpit_device_id = 9, value_down = 1, name = "Fuel selector valve (rotary)", category = "Fuel Control"},
{down = 3003, cockpit_device_id = 9, value_down = 1, name = "Fuel shut-off valve", category = "Fuel Control"},
{down = 3001, up = 3001, cockpit_device_id = 30, value_down = 0.6, value_up = 0, name = "G-meter Reset", category = "Front Dash"},
{down = 3004, cockpit_device_id = 14, value_down = 1, name = "Generator", category = "Right Switch Panel"},
{down = iCommandRecoverHuman, name = "Get new plane - respawn", category = "General"},
{combos = {{key = "JOY_BTN1"}, }, down = iCommandPlaneFire, up = iCommandPlaneFireOff, name = "Gun fire", category = "Stick"},
{down = 3020, cockpit_device_id = 14, value_down = 1, name = "Gun heat", category = "Right Switch Panel"},
{down = 3016, cockpit_device_id = 13, value_down = 1, name = "Gun safety switch (rotary)", category = "Front Switch Box"},
{down = 3007, cockpit_device_id = 13, value_down = -1, name = "Gun safety switch CAMERA SIGHT", category = "Front Switch Box"},
{down = 3007, cockpit_device_id = 13, value_down = 1, name = "Gun safety switch GUN CAMERA SIGHT", category = "Front Switch Box"},
{down = 3007, cockpit_device_id = 13, value_down = 0, name = "Gun safety switch OFF", category = "Front Switch Box"},
{pressed = 3010, cockpit_device_id = 1, value_pressed = -1, name = "Gunsight brightness Decrease", category = "K-14 gunsight"},
{pressed = 3010, cockpit_device_id = 1, value_pressed = 1, name = "Gunsight brightness Increase", category = "K-14 gunsight"},
{down = 3009, cockpit_device_id = 1, value_down = 1, name = "Gunsight fixed ring blanc lever", category = "K-14 gunsight"},
{down = 3008, cockpit_device_id = 1, value_down = 1, name = "Gunsight gyromotor power", category = "K-14 gunsight"},
{down = 3017, cockpit_device_id = 1, value_down = 1, name = "Gunsight mode (rotary)", category = "K-14 gunsight"},
{down = 3003, cockpit_device_id = 1, value_down = 0, name = "Gunsight mode FIXED", category = "K-14 gunsight"},
{down = 3003, cockpit_device_id = 1, value_down = 0.1, name = "Gunsight mode FIXED GYRO", category = "K-14 gunsight"},
{down = 3003, cockpit_device_id = 1, value_down = 0.2, name = "Gunsight mode GYRO", category = "K-14 gunsight"},
{pressed = 3002, cockpit_device_id = 1, value_pressed = -0.7, name = "Gunsight range to target Decrease", category = "K-14 gunsight"},
{pressed = 3002, cockpit_device_id = 1, value_pressed = 0.7, name = "Gunsight range to target Increase", category = "K-14 gunsight"},
{pressed = 3014, cockpit_device_id = 1, value_pressed = -0.5, name = "Gunsight target span Decrease", category = "K-14 gunsight"},
{pressed = 3014, cockpit_device_id = 1, value_pressed = 0.5, name = "Gunsight target span Increase", category = "K-14 gunsight"},
{down = 3004, up = 3004, cockpit_device_id = 15, value_down = 1, value_up = 0, name = "High Blower lamp test", category = "Engine Control Panel"},
{down = 3001, cockpit_device_id = 28, value_down = 0.1, name = "Homing Adapter COMM", category = "Homing Adapter"},
{down = 3004, cockpit_device_id = 28, value_down = 1, name = "Homing Adapter CW/MCW", category = "Homing Adapter"},
{down = 3003, up = 3003, cockpit_device_id = 28, value_down = 1, value_up = 0, name = "Homing Adapter Circuit Breaker", category = "Homing Adapter"},
{down = 3001, cockpit_device_id = 28, value_down = 0.2, name = "Homing Adapter HOMING", category = "Homing Adapter"},
{down = 3007, cockpit_device_id = 28, value_down = 0.2, name = "Homing Adapter Mode", category = "Homing Adapter"},
{down = 3001, cockpit_device_id = 28, value_down = 0, name = "Homing Adapter TRANS", category = "Homing Adapter"},
{down = 3005, cockpit_device_id = 19, value_down = 1, name = "Horizon Cage", category = "Front Dash"},
{pressed = 3006, cockpit_device_id = 19, value_pressed = -1, name = "Horizon cage knob OFF", category = "Front Dash"},
{pressed = 3006, cockpit_device_id = 19, value_pressed = 1, name = "Horizon cage knob ON", category = "Front Dash"},
{pressed = 3004, cockpit_device_id = 19, value_pressed = -1, name = "Horizon pitch Decrease", category = "Front Dash"},
{pressed = 3004, cockpit_device_id = 19, value_pressed = 1, name = "Horizon pitch Increase", category = "Front Dash"},
{down = 3002, cockpit_device_id = 3, value_down = 1, name = "Hydraulic Emergency Release Knob", category = "Systems"},
{down = 3018, cockpit_device_id = 27, value_down = 1, name = "IFF Code", category = "IFF"},
{down = 3012, cockpit_device_id = 27, value_down = -1, name = "IFF Code Decrease", category = "IFF"},
{down = 3012, cockpit_device_id = 27, value_down = 1, name = "IFF Code Increase", category = "IFF"},
{down = 3013, cockpit_device_id = 27, value_down = 1, name = "IFF Detonator Circuit On/Off", category = "IFF"},
{down = 3007, up = 3007, cockpit_device_id = 27, value_down = 1, value_up = 0, name = "IFF Detonator Left", category = "IFF"},
{down = 3008, up = 3008, cockpit_device_id = 27, value_down = 1, value_up = 0, name = "IFF Detonator Right", category = "IFF"},
{down = 3010, cockpit_device_id = 27, value_down = 1, name = "IFF Distress Signal", category = "IFF"},
{down = 3019, cockpit_device_id = 27, value_down = 1, name = "IFF Mode", category = "IFF"},
{down = 3003, cockpit_device_id = 27, value_down = 0, name = "IFF OFF", category = "IFF"},
{down = 3003, cockpit_device_id = 27, value_down = 1, name = "IFF ON", category = "IFF"},
{down = 3009, cockpit_device_id = 27, value_down = 1, name = "IFF Power On/Off", category = "IFF"},
{down = 3003, cockpit_device_id = 27, value_down = -1, name = "IFF TIME", category = "IFF"},
{down = 3006, cockpit_device_id = 13, value_down = 0.3, name = "Ignition switch (rotary)", category = "Front Switch Box"},
{down = 3002, cockpit_device_id = 13, value_down = 0.3, name = "Ignition switch BOTH", category = "Front Switch Box"},
{down = 3002, cockpit_device_id = 13, value_down = 0.2, name = "Ignition switch Left", category = "Front Switch Box"},
{down = 3002, cockpit_device_id = 13, value_down = 0, name = "Ignition switch OFF", category = "Front Switch Box"},
{down = 3002, cockpit_device_id = 13, value_down = 0.1, name = "Ignition switch Right", category = "Front Switch Box"},
{down = iCommandInfoOnOff, name = "Info bar view toggle", category = "General"},
{down = iCommandPlaneJump, name = "Jump into selected aircraft", category = "General"},
{down = iCommandViewFastKeyboard, name = "Keyboard turn rate fast", category = "View"},
{down = iCommandViewNormalKeyboard, name = "Keyboard turn rate normal", category = "View"},
{down = iCommandViewSlowKeyboard, name = "Keyboard turn rate slow", category = "View"},
{down = 3001, cockpit_device_id = 29, value_down = 1, name = "Kneeboard Next Page", category = "Kneeboard"},
{down = iCommandPlaneShowKneeboard, name = "Kneeboard ON/OFF", category = "Kneeboard"},
{down = 3002, cockpit_device_id = 29, value_down = 1, name = "Kneeboard Previous Page", category = "Kneeboard"},
{down = 3003, cockpit_device_id = 29, value_down = 1, name = "Kneeboard current position mark point", category = "Kneeboard"},
{down = iCommandPlaneShowKneeboard, up = iCommandPlaneShowKneeboard, value_down = 1, value_up = -1, name = "Kneeboard glance view", category = "Kneeboard"},
{down = iCommandMarkerStatePlane, name = "Labels Aircraft", category = "Labels"},
{down = iCommandMarkerState, name = "Labels All", category = "Labels"},
{down = iCommandMarkerStateRocket, name = "Labels Missile", category = "Labels"},
{down = iCommandMarkerStateShip, name = "Labels Vehicle & Ship", category = "Labels"},
{down = 3018, up = 3018, cockpit_device_id = 12, value_down = 1, value_up = 0, name = "Landing Gear Safe Light Test", category = "Systems"},
{down = 3007, up = 3007, cockpit_device_id = 12, value_down = 1, value_up = 0, name = "Landing Gear Unsafe Light Test", category = "Systems"},
{down = 3004, cockpit_device_id = 12, value_down = 1, name = "Landing Gear Up/Down", category = "Systems"},
{down = 3004, cockpit_device_id = 10, value_down = 1, name = "Landing Light", category = "Environment System"},
{down = iCommandViewLeftMirrorOn, up = iCommandViewLeftMirrorOff, name = "Mirror glance", category = "View Cockpit"},
{down = 3011, cockpit_device_id = 5, value_down = 0.2, name = "Mixture EMERGENCY FULL RICH", category = "Flight Control"},
{down = 3011, cockpit_device_id = 5, value_down = 0, name = "Mixture IDLE CUT OFF", category = "Flight Control"},
{down = 3011, cockpit_device_id = 5, value_down = 0.1, name = "Mixture RUN", category = "Flight Control"},
{down = 3020, cockpit_device_id = 5, value_down = 1, name = "Mixture control (rotary)", category = "Flight Control"},
{down = iCommandViewFastMouse, name = "Mouse turn rate fast", category = "View"},
{down = iCommandViewNormalMouse, name = "Mouse turn rate normal", category = "View"},
{down = iCommandViewSlowMouse, name = "Mouse turn rate slow", category = "View"},
{down = iCommandChat, name = "Multiplayer chat - mode All", category = "General"},
{down = iCommandFriendlyChat, name = "Multiplayer chat - mode Allies", category = "General"},
{down = iCommandViewNightVisionGogglesOn, name = "Night Vision Goggles", category = "Sensors"},
{pressed = iCommandPlane_Helmet_Brightess_Down, name = "Night Vision Goggles Gain Down", category = "Sensors"},
{pressed = iCommandPlane_Helmet_Brightess_Up, name = "Night Vision Goggles Gain Up", category = "Sensors"},
{down = iCommandViewObjectIgnore, name = "Object exclude ", category = "View Extended"},
{down = iCommandViewObjectsAll, name = "Objects all excluded - include", category = "View Extended"},
{down = iCommandViewSwitchForward, name = "Objects switching direction forward ", category = "View Extended"},
{down = iCommandViewSwitchReverse, name = "Objects switching direction reverse ", category = "View Extended"},
{down = 3007, up = 3007, cockpit_device_id = 15, value_down = 1, value_up = 0, name = "Oil Dilute", category = "Engine Control Panel"},
{down = iCommandOneFrame, name = "One frame mode", category = "General"},
{down = 3002, cockpit_device_id = 7, value_down = 1, name = "Oxygen regulator Deluter lever Auto-Mix On-Off", category = "Systems"},
{down = 3004, cockpit_device_id = 7, value_down = 1, name = "Oxygen regulator Emergency By-Pass Valve", category = "Systems"},
{down = iCommandViewUnlock, name = "Padlock Off (stop padlock)", category = "View Padlock"},
{down = iCommandViewLock, name = "Padlock cycle", category = "View Padlock"},
{down = iCommandThreatMissilePadlock, name = "Padlock missile threat", category = "View Padlock"},
{down = iCommandAllMissilePadlock, name = "Padlock missiles all", category = "View Padlock"},
{down = iCommandViewTerrainLock, name = "Padlock terrain point", category = "View Padlock"},
{down = iCommandBrakeGo, name = "Pause", category = "General"},
{down = iCommandActivePauseOnOff, name = "Pause Active", category = "General"},
{down = 3006, cockpit_device_id = 14, value_down = 1, name = "Pitot heat", category = "Right Switch Panel"},
{down = iCommandTrkEsc, name = "Playback track cancel", category = "General"},
{down = 3018, cockpit_device_id = 14, value_down = 1, name = "Position light tail (rotary)", category = "Right Switch Panel"},
{down = 3009, cockpit_device_id = 14, value_down = 1, name = "Position light tail BRIGHT", category = "Right Switch Panel"},
{down = 3009, cockpit_device_id = 14, value_down = -1, name = "Position light tail DIM", category = "Right Switch Panel"},
{down = 3009, cockpit_device_id = 14, value_down = 0, name = "Position light tail OFF", category = "Right Switch Panel"},
{down = 3017, cockpit_device_id = 14, value_down = 1, name = "Position lights wing (rotary)", category = "Right Switch Panel"},
{down = 3008, cockpit_device_id = 14, value_down = 1, name = "Position lights wing BRIGHT", category = "Right Switch Panel"},
{down = 3008, cockpit_device_id = 14, value_down = -1, name = "Position lights wing DIM", category = "Right Switch Panel"},
{down = 3008, cockpit_device_id = 14, value_down = 0, name = "Position lights wing OFF", category = "Right Switch Panel"},
{down = 3011, up = 3011, cockpit_device_id = 15, value_down = 1, value_up = 0, name = "Primer", category = "Engine Control Panel"},
{pressed = 3015, cockpit_device_id = 5, value_pressed = 1, name = "Propeller & Mixture Lock", category = "Flight Control"},
{pressed = 3015, cockpit_device_id = 5, value_pressed = -1, name = "Propeller & Mixture Unlock", category = "Flight Control"},
{down = 3009, cockpit_device_id = 5, value_down = 0.2, name = "Radiator coolant Auto", category = "Radiator Air Controls"},
{down = 3001, up = 3001, cockpit_device_id = 5, value_down = 0.1, value_up = 0, name = "Radiator coolant Close", category = "Radiator Air Controls"},
{down = 3005, cockpit_device_id = 5, value_down = 1, name = "Radiator coolant Cover", category = "Radiator Air Controls"},
{down = 3001, up = 3001, cockpit_device_id = 5, value_down = 0.3, value_up = 0, name = "Radiator coolant Open", category = "Radiator Air Controls"},
{down = 3010, cockpit_device_id = 5, value_down = 0.2, name = "Radiator oil Auto", category = "Radiator Air Controls"},
{down = 3002, up = 3002, cockpit_device_id = 5, value_down = 0.1, value_up = 0, name = "Radiator oil Close", category = "Radiator Air Controls"},
{down = 3006, cockpit_device_id = 5, value_down = 1, name = "Radiator oil Cover", category = "Radiator Air Controls"},
{down = 3002, up = 3002, cockpit_device_id = 5, value_down = 0.3, value_up = 0, name = "Radiator oil Open", category = "Radiator Air Controls"},
{down = 3008, up = 3008, cockpit_device_id = 24, value_down = -1, value_up = 0, name = "Radio Mode T", category = "VHF Radio"},
{combos = {{key = "JOY_BTN11", reformers = {"JOY_BTN4", }}, }, down = 3009, cockpit_device_id = 24, value_down = 1, name = "Radio Power", category = "VHF Radio"},
{combos = {{key = "JOY_BTN11"}, }, down = 3010, cockpit_device_id = 24, value_down = 1, name = "Radio chanel A", category = "VHF Radio"},
{combos = {{key = "JOY_BTN12"}, }, down = 3011, cockpit_device_id = 24, value_down = 1, name = "Radio chanel B", category = "VHF Radio"},
{combos = {{key = "JOY_BTN13"}, }, down = 3012, cockpit_device_id = 24, value_down = 1, name = "Radio chanel C", category = "VHF Radio"},
{combos = {{key = "JOY_BTN14"}, }, down = 3013, cockpit_device_id = 24, value_down = 1, name = "Radio chanel D", category = "VHF Radio"},
{pressed = 3014, cockpit_device_id = 24, value_pressed = -1, name = "Radio lights dimmer Decrease", category = "VHF Radio"},
{pressed = 3014, cockpit_device_id = 24, value_pressed = 1, name = "Radio lights dimmer Increase", category = "VHF Radio"},
{down = 3007, cockpit_device_id = 24, value_down = 0, name = "Radio mode R", category = "VHF Radio"},
{down = 3007, cockpit_device_id = 24, value_down = 1, name = "Radio mode REM", category = "VHF Radio"},
{down = 3018, cockpit_device_id = 24, value_down = 1, name = "Radio mode switch locking lever", category = "VHF Radio"},
{down = 3002, cockpit_device_id = 25, value_down = 1, name = "Rear warning radar Power", category = "Rear Warning Radar"},
{down = 3003, up = 3003, cockpit_device_id = 25, value_down = 1, value_up = 0, name = "Rear warning radar Test", category = "Rear Warning Radar"},
{pressed = 3005, cockpit_device_id = 25, value_pressed = -1, name = "Rear warning radar signal light Decrease", category = "Rear Warning Radar"},
{pressed = 3005, cockpit_device_id = 25, value_pressed = 1, name = "Rear warning radar signal light Increase", category = "Rear Warning Radar"},
{down = iCommandMissionResourcesManagement, name = "Rearming and Refueling Window", category = "General"},
{down = 3032, cockpit_device_id = 14, value_down = 1, name = "Recognition light amber (rotary)", category = "Right Switch Panel"},
{down = 3023, cockpit_device_id = 14, value_down = -1, name = "Recognition light amber Key", category = "Right Switch Panel"},
{down = 3023, cockpit_device_id = 14, value_down = 0, name = "Recognition light amber Off", category = "Right Switch Panel"},
{down = 3023, cockpit_device_id = 14, value_down = 1, name = "Recognition light amber Steady", category = "Right Switch Panel"},
{down = 3031, cockpit_device_id = 14, value_down = 1, name = "Recognition light green (rotary)", category = "Right Switch Panel"},
{down = 3022, cockpit_device_id = 14, value_down = -1, name = "Recognition light green Key", category = "Right Switch Panel"},
{down = 3022, cockpit_device_id = 14, value_down = 0, name = "Recognition light green Off", category = "Right Switch Panel"},
{down = 3022, cockpit_device_id = 14, value_down = 1, name = "Recognition light green Steady", category = "Right Switch Panel"},
{down = 3030, cockpit_device_id = 14, value_down = 1, name = "Recognition light red (rotary)", category = "Right Switch Panel"},
{down = 3021, cockpit_device_id = 14, value_down = -1, name = "Recognition light red Key", category = "Right Switch Panel"},
{down = 3021, cockpit_device_id = 14, value_down = 0, name = "Recognition light red Off", category = "Right Switch Panel"},
{down = 3021, cockpit_device_id = 14, value_down = 1, name = "Recognition light red Steady", category = "Right Switch Panel"},
{down = 3024, up = 3024, cockpit_device_id = 14, value_down = 1, value_up = 0, name = "Recognition lights key", category = "Right Switch Panel"},
{down = iCommandViewCameraReturn, name = "Return camera", category = "View Cockpit"},
{down = iCommandViewCameraBaseReturn, name = "Return camera base", category = "View Cockpit"},
{down = 3012, cockpit_device_id = 4, value_down = -1, name = "Rocket counter reset", category = "Rocket Control Panel"},
{down = 3011, cockpit_device_id = 4, value_down = 1, name = "Rockets Delay/Inst", category = "Rocket Control Panel"},
{down = 3015, cockpit_device_id = 4, value_down = 1, name = "Rockets release control switch (rotary)", category = "Rocket Control Panel"},
{down = 3007, cockpit_device_id = 4, value_down = 0.2, name = "Rockets release control switch AUTO", category = "Rocket Control Panel"},
{down = 3007, cockpit_device_id = 4, value_down = 0, name = "Rockets release control switch OFF", category = "Rocket Control Panel"},
{down = 3007, cockpit_device_id = 4, value_down = 0.1, name = "Rockets release control switch SINGLE", category = "Rocket Control Panel"},
{down = iCommandViewSaveAngles, name = "Save Cockpit Angles", category = "View Cockpit"},
{down = iCommandScoresWindowToggle, name = "Score window", category = "General"},
{down = iCommandScreenShot, name = "Screenshot", category = "General"},
{down = iCommandDebriefing, name = "Show debriefing window", category = "General"},
{down = iCommandCockpitShowPilotOnOff, name = "Show pilot", category = "General"},
{down = 3008, up = 3008, cockpit_device_id = 13, value_down = 1, value_up = 0, name = "Silence Horn", category = "Front Switch Box"},
{down = iCommandViewSnapView0, up = iCommandViewSnapViewStop, name = "Snap View 0", category = "View Cockpit"},
{down = iCommandViewSnapView1, up = iCommandViewSnapViewStop, name = "Snap View 1", category = "View Cockpit"},
{down = iCommandViewSnapView2, up = iCommandViewSnapViewStop, name = "Snap View 2", category = "View Cockpit"},
{down = iCommandViewSnapView3, up = iCommandViewSnapViewStop, name = "Snap View 3", category = "View Cockpit"},
{down = iCommandViewSnapView4, up = iCommandViewSnapViewStop, name = "Snap View 4", category = "View Cockpit"},
{down = iCommandViewSnapView5, up = iCommandViewSnapViewStop, name = "Snap View 5", category = "View Cockpit"},
{down = iCommandViewSnapView6, up = iCommandViewSnapViewStop, name = "Snap View 6", category = "View Cockpit"},
{down = iCommandViewSnapView7, up = iCommandViewSnapViewStop, name = "Snap View 7", category = "View Cockpit"},
{down = iCommandViewSnapView8, up = iCommandViewSnapViewStop, name = "Snap View 8", category = "View Cockpit"},
{down = iCommandViewSnapView9, up = iCommandViewSnapViewStop, name = "Snap View 9", category = "View Cockpit"},
{down = iCommandEnginesStart, name = "Start Procedure", category = "Cheat"},
{down = 3008, up = 3008, cockpit_device_id = 15, value_down = 1, value_up = 0, name = "Starter", category = "Engine Control Panel"},
{down = 3010, cockpit_device_id = 15, value_down = 1, name = "Starter Switch Cover", category = "Engine Control Panel"},
{down = 3015, up = 3015, cockpit_device_id = 12, value_down = 1, value_up = 0, name = "Stick lock in the Forward Position", category = "Flight Control"},
{down = 3016, up = 3016, cockpit_device_id = 12, value_down = 1, value_up = 0, name = "Stick lock in the Neutral Position", category = "Flight Control"},
{down = iCommandEnginesStop, name = "Stop Procedure", category = "Cheat"},
{down = 3001, cockpit_device_id = 15, value_down = 0, name = "Supercharger switch AUTO", category = "Engine Control Panel"},
{down = 3003, cockpit_device_id = 15, value_down = 1, name = "Supercharger switch Cover", category = "Engine Control Panel"},
{down = 3001, up = 3001, cockpit_device_id = 15, value_down = 0.2, value_up = 0.1, name = "Supercharger switch HIGH", category = "Engine Control Panel"},
{down = 3001, cockpit_device_id = 15, value_down = 0.1, name = "Supercharger switch LOW", category = "Engine Control Panel"},
{pressed = 3013, cockpit_device_id = 5, value_pressed = 1, name = "Throttle Control Lock", category = "Flight Control"},
{pressed = 3013, cockpit_device_id = 5, value_pressed = -1, name = "Throttle Control Unlock", category = "Flight Control"},
{pressed = 3023, cockpit_device_id = 5, value_pressed = -1, name = "Throttle Decrease", category = "Flight Control"},
{pressed = 3023, cockpit_device_id = 5, value_pressed = 1, name = "Throttle Increase", category = "Flight Control"},
{down = iCommandAccelerate, name = "Time accelerate", category = "General"},
{down = iCommandDecelerate, name = "Time decelerate", category = "General"},
{down = iCommandNoAcceleration, name = "Time normal", category = "General"},
{combos = {{key = "JOY_BTN_POV1_L", reformers = {"LCtrl", }}, }, pressed = 3011, cockpit_device_id = 12, value_pressed = -0.1, name = "Trim Aileron Left", category = "Flight Control"},
{combos = {{key = "JOY_BTN_POV1_R", reformers = {"LCtrl", }}, }, pressed = 3011, cockpit_device_id = 12, value_pressed = 0.1, name = "Trim Aileron Right", category = "Flight Control"},
{combos = {{key = "JOY_BTN_POV1_U", reformers = {"LCtrl", }}, }, pressed = 3012, cockpit_device_id = 12, value_pressed = 0.05, name = "Trim Elevator Down", category = "Flight Control"},
{combos = {{key = "JOY_BTN_POV1_D", reformers = {"LCtrl", }}, }, pressed = 3012, cockpit_device_id = 12, value_pressed = -0.05, name = "Trim Elevator Up", category = "Flight Control"},
{combos = {{key = "JOY_BTN_POV1_L", reformers = {"LCtrl", "LShift", }}, }, pressed = 3013, cockpit_device_id = 12, value_pressed = -0.1, name = "Trim Rudder Left", category = "Flight Control"},
{combos = {{key = "JOY_BTN_POV1_R", reformers = {"LCtrl", "LShift", }}, }, pressed = 3013, cockpit_device_id = 12, value_pressed = 0.1, name = "Trim Rudder Right", category = "Flight Control"},
{down = 3014, cockpit_device_id = 12, value_down = 1, name = "Trimmers Reset", category = "Flight Control"},
{pressed = 3016, cockpit_device_id = 24, value_pressed = -1, name = "VHF radio volume Decrease", category = "VHF Radio"},
{pressed = 3016, cockpit_device_id = 24, value_pressed = 1, name = "VHF radio volume Increase", category = "VHF Radio"},
{combos = {{key = "JOY_BTN5"}, }, pressed = iCommandViewCenter, name = "View Center", category = "View"},
{combos = {{key = "JOY_BTN_POV1_DL"}, }, pressed = iCommandViewDownLeftSlow, up = iCommandViewStopSlow, name = "View Down Left slow", category = "View"},
{combos = {{key = "JOY_BTN_POV1_DR"}, }, pressed = iCommandViewDownRightSlow, up = iCommandViewStopSlow, name = "View Down Right slow", category = "View"},
{combos = {{key = "JOY_BTN_POV1_D"}, }, pressed = iCommandViewDownSlow, up = iCommandViewStopSlow, name = "View Down slow", category = "View"},
{combos = {{key = "JOY_BTN_POV1_L"}, }, pressed = iCommandViewLeftSlow, up = iCommandViewStopSlow, name = "View Left slow", category = "View"},
{combos = {{key = "JOY_BTN_POV1_R"}, }, pressed = iCommandViewRightSlow, up = iCommandViewStopSlow, name = "View Right slow", category = "View"},
{combos = {{key = "JOY_BTN_POV1_UL"}, }, pressed = iCommandViewUpLeftSlow, up = iCommandViewStopSlow, name = "View Up Left slow", category = "View"},
{combos = {{key = "JOY_BTN_POV1_UR"}, }, pressed = iCommandViewUpRightSlow, up = iCommandViewStopSlow, name = "View Up Right slow", category = "View"},
{combos = {{key = "JOY_BTN_POV1_U"}, }, pressed = iCommandViewUpSlow, up = iCommandViewStopSlow, name = "View Up slow", category = "View"},
{down = iCommandViewAll, name = "View all mode", category = "View Extended"},
{pressed = iCommandViewDown, up = iCommandViewStop, name = "View down", category = "View Cockpit"},
{pressed = iCommandViewDownLeft, up = iCommandViewStop, name = "View down left", category = "View Cockpit"},
{pressed = iCommandViewDownRight, up = iCommandViewStop, name = "View down right", category = "View Cockpit"},
{down = iCommandViewEnemies, name = "View enemies mode", category = "View Extended"},
{down = iCommandViewFriends, name = "View friends mode", category = "View Extended"},
{pressed = iCommandViewLeft, up = iCommandViewStop, name = "View left", category = "View Cockpit"},
{pressed = iCommandViewRight, up = iCommandViewStop, name = "View right", category = "View Cockpit"},
{pressed = iCommandViewUp, up = iCommandViewStop, name = "View up", category = "View Cockpit"},
{pressed = iCommandViewUpLeft, up = iCommandViewStop, name = "View up left", category = "View Cockpit"},
{pressed = iCommandViewUpRight, up = iCommandViewStop, name = "View up right", category = "View Cockpit"},
{down = iCommandPlane_P_51_WarEmergencyPower, name = "War Emergency Power", category = "Flight Control"},
{pressed = 3028, cockpit_device_id = 5, value_pressed = -1, name = "Warm Air Control to HOT", category = "Carburetor Air Controls"},
{pressed = 3028, cockpit_device_id = 5, value_pressed = 1, name = "Warm Air Control to NORMAL", category = "Carburetor Air Controls"},
{combos = {{key = "JOY_BTN2"}, }, down = iCommandPlanePickleOn, up = iCommandPlanePickleOff, name = "Weapon release", category = "Stick"},
{down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = "Wheel brake Both", category = "Systems"},
{down = iCommandPlaneWheelBrakeLeftOn, up = iCommandPlaneWheelBrakeLeftOff, name = "Wheel brake Left", category = "Systems"},
{down = 3006, up = 3006, cockpit_device_id = 12, value_down = 1, value_up = 0, name = "Wheel brake Parking", category = "Systems"},
{down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff, name = "Wheel brake Right", category = "Systems"},
{pressed = iCommandViewExternalZoomIn, up = iCommandViewExternalZoomInStop, name = "Zoom external in", category = "View"},
{down = iCommandViewExternalZoomDefault, name = "Zoom external normal", category = "View"},
{pressed = iCommandViewExternalZoomOut, up = iCommandViewExternalZoomOutStop, name = "Zoom external out", category = "View"},
{pressed = iCommandViewForward, up = iCommandViewForwardStop, name = "Zoom in", category = "View Cockpit"},
{pressed = iCommandViewForwardSlow, up = iCommandViewForwardSlowStop, name = "Zoom in slow", category = "View"},
{down = iCommandViewAngleDefault, name = "Zoom normal", category = "View"},
{pressed = iCommandViewBack, up = iCommandViewBackStop, name = "Zoom out", category = "View Cockpit"},
{pressed = iCommandViewBackSlow, up = iCommandViewBackSlowStop, name = "Zoom out slow", category = "View"},
},
axisCommands = {
{action = iCommandViewHorizontalAbs, name = "Absolute Camera Horizontal View"},
{action = iCommandViewVerticalAbs, name = "Absolute Camera Vertical View"},
{action = iCommandViewHorTransAbs, name = "Absolute Horizontal Shift Camera View"},
{action = iCommandViewLongitudeTransAbs, name = "Absolute Longitude Shift Camera View"},
{action = iCommandViewRollAbs, name = "Absolute Roll Shift Camera View"},
{action = iCommandViewVertTransAbs, name = "Absolute Vertical Shift Camera View"},
{action = 3007, cockpit_device_id = 6, name = "Canopy Crank"},
{action = 3004, cockpit_device_id = 13, name = "Cockpit Lights"},
{action = 3018, cockpit_device_id = 5, name = "Cold Air Control"},
{action = 3026, cockpit_device_id = 5, name = "Engine RPM Setting"},
{action = 3017, cockpit_device_id = 12, name = "Flaps"},
{action = 3013, cockpit_device_id = 1, name = "K-14 Brightness"},
{action = 3011, cockpit_device_id = 1, name = "K-14 Range to target"},
{action = 3012, cockpit_device_id = 1, name = "K-14 Target span"},
{action = 3006, cockpit_device_id = 10, name = "Left Fluorescent Light"},
{combos = {{key = "JOY_Y"}, }, action = iCommandPlanePitch, name = "Pitch"},
{action = 3017, cockpit_device_id = 5, name = "Propeller & Mixture Lock"},
{action = 3011, cockpit_device_id = 14, name = "Right Fluorescent Light"},
{combos = {{key = "JOY_X"}, }, action = iCommandPlaneRoll, name = "Roll"},
{action = iCommandPlaneRudder, name = "Rudder"},
{action = 3006, cockpit_device_id = 25, name = "Tail Warning Radar Light Brightness"},
{action = 3025, cockpit_device_id = 5, name = "Throttle"},
{action = 3016, cockpit_device_id = 5, name = "Throttle Control Lock"},
{action = iCommandPlaneTrimRollAbs, name = "Trim Aileron"},
{action = iCommandPlaneTrimPitchAbs, name = "Trim Elevator"},
{action = iCommandPlaneTrimRudderAbs, name = "Trim Rudder"},
{action = 3019, cockpit_device_id = 24, name = "VHF Radio Volume"},
{action = 3029, cockpit_device_id = 5, name = "Warm Air Control"},
{action = iCommandWheelBrake, name = "Wheel Brake"},
{action = iCommandLeftWheelBrake, name = "Wheel Brake Left"},
{action = iCommandRightWheelBrake, name = "Wheel Brake Right"},
{action = iCommandViewZoomAbs, name = "Zoom View"},
},
}
end